using ConnectorLib.JSON;
using Inventory;
using PugMod;

namespace CrowdControl.Delegates.Effects.Implementations
{
    [Effect("food_refill")]
    public class FoodRefill : Effect
    {
        public FoodRefill(CrowdControl mod, NetworkClient client) : base(mod, client) { }
        
        public override EffectResponse Start(EffectRequest request)
        {
            PlayerController player = Manager.main.player;
            if (player == null) return EffectResponse.Retry(request.ID, StandardErrors.PlayerNotFound);

            HungerCD newHunger = player.hungerComponent;
            newHunger.hunger = HungerCD.MAX_HUNGER;
            EntityUtility.SetComponentData(player.entity, player.world, newHunger);
            API.Server.World.EntityManager.SetComponentData(player.entity, newHunger);
            return EffectResponse.Success(request.ID);
        }
    }
}